/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterItemOverrides {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ItemInit.SOULSPRING_LAMP.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "soulspring_state"), (stack, level, entity, id) -> {
                CompoundTag tag = stack.m_41784_();
                if (tag.m_128471_("Lit")) {
                    return tag.m_128451_("Fuel") > 43 ? 3.0f : (tag.m_128451_("Fuel") > 22 ? 2.0f : 1.0f);
                }
                return 0.0f;
            });
            ItemProperties.register((Item)((Item)ItemInit.FILLED_WATERSKIN.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "water_temperature"), (stack, level, entity, id) -> stack.m_41784_().m_128457_("Temperature"));
            ItemProperties.register((Item)((Item)ItemInit.THERMOMETER.get()), (ResourceLocation)new ResourceLocation("cold_sweat", "temperature"), (stack, level, livingEntity, id) -> {
                LivingEntity entity;
                Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
                if (entity != null) {
                    ItemFrame frame;
                    double worldTemp;
                    double maxTemp;
                    double minTemp = livingEntity != null ? Temperature.get(livingEntity, Temperature.Trait.FREEZING_POINT) : ConfigSettings.MIN_TEMP.get();
                    double d = maxTemp = livingEntity != null ? Temperature.get(livingEntity, Temperature.Trait.BURNING_POINT) : ConfigSettings.MAX_TEMP.get();
                    if (!entity.getPersistentData().m_128441_("WorldTempTimestamp") || (entity.f_19797_ % 20 == 0 || entity instanceof Player && entity.f_19797_ % 2 == 0) && entity.getPersistentData().m_128451_("WorldTempTimestamp") != entity.f_19797_) {
                        double d2;
                        if (entity instanceof LivingEntity) {
                            LivingEntity living = entity;
                            d2 = EntityTempManager.getTemperatureCap((Entity)living).map(cap -> cap.getTrait(Temperature.Trait.WORLD)).orElse(0.0);
                        } else {
                            d2 = Temperature.getTemperatureAt(entity.m_20183_(), entity.f_19853_);
                        }
                        worldTemp = d2;
                        entity.getPersistentData().m_128347_("WorldTemp", worldTemp);
                        entity.getPersistentData().m_128405_("WorldTempTimestamp", entity.f_19797_);
                    } else {
                        worldTemp = entity.getPersistentData().m_128459_("WorldTemp");
                    }
                    if (entity instanceof ItemFrame && Minecraft.m_91087_().m_91290_().f_114359_ == (frame = (ItemFrame)entity)) {
                        boolean celsius = ConfigSettings.CELSIUS.get();
                        ChatFormatting tempColor = switch (Overlays.getGaugeSeverity(worldTemp, minTemp, maxTemp)) {
                            case 0 -> ChatFormatting.WHITE;
                            case 2, 3 -> ChatFormatting.GOLD;
                            case 4 -> ChatFormatting.RED;
                            case -3, -2 -> ChatFormatting.AQUA;
                            case -4 -> ChatFormatting.BLUE;
                            default -> ChatFormatting.RESET;
                        };
                        int convertedTemp = (int)Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true) + ConfigSettings.TEMP_OFFSET.get();
                        frame.m_31822_().m_41714_((Component)Component.m_237113_((String)(convertedTemp + " " + (celsius ? Temperature.Units.C.getFormattedName() : Temperature.Units.F.getFormattedName()))).m_130940_(tempColor));
                    }
                    double worldTempAdjusted = Overlays.getWorldSeverity(worldTemp, minTemp, maxTemp) * 1.01;
                    return (float)worldTempAdjusted;
                }
                return 0.0f;
            });
        });
    }
}

